/*
 * Decompiled with CFR 0.152.
 */
package com.vmx;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufDataOutputStream
implements DataOutput {
    final byte[] buffer;
    int bmax;
    int bpos;
    OutputStream os;

    public BufDataOutputStream(int bufsize, OutputStream oos) throws IOException {
        if (bufsize <= 0) {
            throw new IOException("Buffer size must be greater than 0");
        }
        this.bmax = bufsize;
        this.bpos = 0;
        this.buffer = new byte[this.bmax];
        this.os = oos;
    }

    public void close() throws IOException {
        this.flush();
        this.os.close();
    }

    public void flush() throws IOException {
        this.os.write(this.buffer, 0, this.bpos);
        this.bpos = 0;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int n;
        int pos = off;
        for (int rest = len; rest > 0; rest -= n) {
            if (this.bpos >= this.bmax) {
                this.flush();
            }
            if ((n = rest) > this.bmax - this.bpos) {
                n = this.bmax - this.bpos;
            }
            System.arraycopy(b, pos, this.buffer, this.bpos, n);
            pos += n;
            this.bpos += n;
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        if (this.bpos >= this.bmax) {
            this.flush();
        }
        this.buffer[this.bpos++] = (byte)b;
    }

    public void writeBoolean(boolean b) throws IOException {
        int bb = 0;
        if (b) {
            bb = 1;
        }
        this.write(bb);
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public void writeChar(int c) throws IOException {
        this.write(c >> 8 & 0xFF);
        this.write(c & 0xFF);
    }

    public void writeChars(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeInt(int i) throws IOException {
        this.write(i >> 24 & 0xFF);
        this.write(i >> 16 & 0xFF);
        this.write(i >> 8 & 0xFF);
        this.write(i & 0xFF);
    }

    public void writeLong(long l) throws IOException {
        this.write((int)(l >> 56 & 0xFFL));
        this.write((int)(l >> 48 & 0xFFL));
        this.write((int)(l >> 40 & 0xFFL));
        this.write((int)(l >> 32 & 0xFFL));
        this.write((int)(l >> 24 & 0xFFL));
        this.write((int)(l >> 16 & 0xFFL));
        this.write((int)(l >> 8 & 0xFFL));
        this.write((int)(l & 0xFFL));
    }

    public void writeShort(int s) throws IOException {
        this.write(s >> 8 & 0xFF);
        this.write(s & 0xFF);
    }

    public void writeUTF(String s) throws IOException {
        this.flush();
        DataOutputStream dos = new DataOutputStream(this.os);
        dos.writeUTF(s);
        dos.flush();
    }
}

