/*
 * Decompiled with CFR 0.152.
 */
package Spider;

import Spider.SpiderMIDlet;
import com.vmx.BufDataInputStream;
import com.vmx.BufDataOutputStream;
import com.vmx.StubFileReader;
import com.vmx.StubFileWriter;
import com.vmx.StubGetter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class SpiderCanvas
extends Canvas {
    public int diff;
    public Form HSBox;
    Random r;
    Image cards;
    Image back;
    int rest;
    int frest;
    int s1x;
    int s1y;
    int s2x;
    int s2y;
    int s1;
    int s2;
    int sing;
    int scroll;
    int KEY_LEFT;
    int KEY_RIGHT;
    int KEY_UP;
    int KEY_DOWN;
    int KEY_FIRE;
    final int[][] state = new int[10][104];
    final int[] n = new int[10];
    final boolean[] flags = new boolean[104];
    final int[] undo_from = new int[32];
    final int[] undo_to = new int[32];
    final int[] undo_n = new int[32];
    final int[][] drawbuf = new int[10][5];
    int undoes;
    int moves;
    int score;
    Command ScoreC;
    boolean won;
    Font mFont;
    Image minif;
    boolean pSTAR;
    boolean pPOUND;
    boolean dyncards;
    SpiderMIDlet mid;
    String ScorePrefix;

    public SpiderCanvas(SpiderMIDlet midd) {
        this.mid = midd;
        this.ScoreC = null;
        this.setFullScreenMode(true);
        this.mFont = Font.getFont((int)0, (int)1, (int)0);
        this.won = false;
        this.undoes = 0;
        this.moves = 0;
        this.score = 500;
        this.KEY_LEFT = this.getKeyCode(2);
        this.KEY_RIGHT = this.getKeyCode(5);
        this.KEY_UP = this.getKeyCode(1);
        this.KEY_DOWN = this.getKeyCode(6);
        this.KEY_FIRE = this.getKeyCode(8);
        this.diff = 1;
        this.dyncards = true;
        if (!this.loadSettings()) {
            this.saveSettings();
        }
        this.scroll = -12;
        this.pPOUND = false;
        this.pSTAR = false;
        this.s1x = 0;
        this.s1y = 5;
        this.s2x = -1;
        this.s2y = 0;
        this.s2 = 0;
        this.s1 = 0;
        this.sing = 0;
        this.frest = 5;
        try {
            this.r = new Random();
            this.cards = Image.createImage((String)"/cards.png");
            this.back = Image.createImage((String)"/back.png");
            this.minif = Image.createImage((String)"/font.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.HSBox = new Form(this.mid.HighscoreST[0]);
        this.HSBox.append((Item)new StringItem(this.mid.HighscoreST[1], ""));
        this.HSBox.append((Item)new StringItem(this.mid.HighscoreST[2], ""));
        this.HSBox.append((Item)new StringItem(this.mid.HighscoreST[3], ""));
        this.HSBox.addCommand(new Command(this.mid.HighscoreST[4], 4, 0));
        this.ScorePrefix = this.mid.CommandST[14];
        this.loadHighscores();
        this.restart();
    }

    public boolean loadSettings() {
        try {
            RecordStore recs = RecordStore.openRecordStore((String)"SpiderSettings", (boolean)false);
            RecordEnumeration en = recs.enumerateRecords(null, null, true);
            byte[] data = en.nextRecord();
            this.dyncards = data[0] > 0;
            this.diff = data[1];
            recs.closeRecordStore();
        }
        catch (RecordStoreException rsx) {
            return false;
        }
        return true;
    }

    public boolean saveSettings() {
        try {
            RecordStore.deleteRecordStore((String)"SpiderSettings");
        }
        catch (RecordStoreException rsx) {
            // empty catch block
        }
        try {
            RecordStore recs = RecordStore.openRecordStore((String)"SpiderSettings", (boolean)true);
            byte[] data = new byte[]{this.dyncards ? (byte)1 : 0, (byte)this.diff};
            recs.addRecord(data, 0, data.length);
            recs.closeRecordStore();
        }
        catch (RecordStoreException rsx) {
            return false;
        }
        return true;
    }

    public int nextCard() {
        int i = -1;
        for (int rn = this.r.nextInt(this.rest) + 1; i < 104 && rn > 0; --rn) {
            ++i;
            while (i < 104 && this.flags[i]) {
                ++i;
            }
        }
        --this.rest;
        this.flags[i] = true;
        return i + 1;
    }

    protected int cardNo(int i, int j) {
        int m = this.state[i][j];
        if (m > 0) {
            m = this.diff == 0 ? (m - 1) % 13 + 1 : (this.diff == 1 ? (m - 1) % 26 + 1 : (m - 1) % 52 + 1);
        } else {
            return 0;
        }
        return m;
    }

    public void undoClear() {
        this.undoes = 0;
    }

    public void undoSetFlag(boolean x) {
        if (this.undoes > 0) {
            int n = this.undoes - 1;
            this.undo_from[n] = this.undo_from[n] & 0xF;
            if (x) {
                int n2 = this.undoes - 1;
                this.undo_from[n2] = this.undo_from[n2] | 0x10;
            }
        }
    }

    public void undoPush(int from, int to, int c) {
        if (this.undoes >= 32) {
            for (int i = 0; i < 31; ++i) {
                this.undo_from[i] = this.undo_from[i + 1];
                this.undo_to[i] = this.undo_to[i + 1];
                this.undo_n[i] = this.undo_n[i + 1];
            }
            --this.undoes;
        }
        this.undo_from[this.undoes] = from;
        this.undo_to[this.undoes] = to;
        this.undo_n[this.undoes] = c;
        ++this.undoes;
    }

    public void undo() {
        if (this.undoes > 0) {
            ++this.moves;
            --this.score;
            --this.undoes;
            int from = this.undo_from[this.undoes] & 0xF;
            int to = this.undo_to[this.undoes];
            int c = this.undo_n[this.undoes];
            if ((this.undo_from[this.undoes] & 0x10) > 0) {
                this.state[from][this.n[from] - 1] = -this.state[from][this.n[from] - 1];
            }
            for (int i = 0; i < c; ++i) {
                this.state[from][this.n[from] + i] = this.state[to][this.n[to] - c + i];
            }
            int n = to;
            this.n[n] = this.n[n] - c;
            int n2 = from;
            this.n[n2] = this.n[n2] + c;
            this.s2x = -1;
            this.s2 = 0;
            this.s1 = 0;
            this.sing = 0;
            this.s1y = this.n[this.s1x] - 1;
            while (this.s1y > 0 && this.cardNo(this.s1x, this.s1y) == this.cardNo(this.s1x, this.s1y - 1) - 1 && (this.state[this.s1x][this.s1y] - 1) % 13 == (this.state[this.s1x][this.s1y - 1] - 1) % 13 - 1) {
                --this.s1y;
            }
            this.repaint();
        }
    }

    public int openCard(int id) {
        if (id == 0) {
            return this.nextCard();
        }
        if (id < 0) {
            return -id;
        }
        return id;
    }

    public void staticate() {
        int i;
        int j;
        for (j = 0; j < 5; ++j) {
            for (i = 0; i < 10; ++i) {
                if (this.drawbuf[i][j] != 0) continue;
                this.drawbuf[i][j] = -this.nextCard();
            }
        }
        j = 0;
        while (true) {
            boolean nb = false;
            for (i = 0; i < 10; ++i) {
                if (this.n[i] <= j) continue;
                if (this.state[i][j] == 0) {
                    this.state[i][j] = -this.nextCard();
                }
                nb = true;
            }
            if (!nb) break;
            ++j;
        }
    }

    public void restart() {
        int j;
        int i;
        this.won = false;
        this.undoes = 0;
        this.moves = 0;
        this.score = 500;
        this.scroll = -10;
        this.s1x = 0;
        this.s1y = 5;
        this.s2x = -1;
        this.s2y = 0;
        this.s2 = 0;
        this.s1 = 0;
        this.sing = 0;
        this.frest = 5;
        this.rest = 104;
        for (i = 0; i < 104; ++i) {
            this.flags[i] = false;
        }
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 5; ++j) {
                this.drawbuf[i][j] = 0;
            }
        }
        for (i = 0; i < 4; ++i) {
            this.n[i] = 6;
            for (j = 0; j < 5; ++j) {
                this.state[i][j] = 0;
            }
            this.state[i][5] = this.nextCard();
        }
        for (i = 4; i < 10; ++i) {
            this.n[i] = 5;
            for (j = 0; j < 4; ++j) {
                this.state[i][j] = 0;
            }
            this.state[i][4] = this.nextCard();
        }
        if (!this.dyncards) {
            this.staticate();
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        int dm;
        g.drawImage(this.back, 0, 0, 0);
        if (this.won) {
            String DiffStr = "";
            switch (this.diff) {
                case 0: {
                    DiffStr = this.mid.CommandST[16];
                    break;
                }
                case 1: {
                    DiffStr = this.mid.CommandST[17];
                    break;
                }
                case 2: {
                    DiffStr = this.mid.CommandST[18];
                }
            }
            g.setFont(this.mFont);
            g.setColor(0xFFFFFF);
            int k = this.mFont.getHeight();
            g.drawString(this.mid.CommandST[15], 66, 0, 1 | 0x10);
            g.drawString(DiffStr, 66, k + 3, 1 | 0x10);
            g.drawString(this.mid.CommandST[14] + String.valueOf(this.score), 66, 2 * (k + 3), 1 | 0x10);
            return;
        }
        int rnf = 0;
        for (dm = 1; dm < dm * 10 && this.score >= dm; dm *= 10) {
            ++rnf;
        }
        g.setColor(0);
        g.fillRect(131 + this.scroll, 2, 9, 1 + rnf * 6);
        dm = 1;
        int i = rnf - 1;
        while (i >= 0) {
            int nn = this.score / dm % 10;
            g.drawRegion(this.minif, 0, 5 * nn, 7, 5, 0, 132 + this.scroll, 3 + i * 6, 4 | 0x10);
            --i;
            dm *= 10;
        }
        for (i = 0; i < this.frest; ++i) {
            g.drawRegion(this.cards, 1092, 0, 21, 15, 0, 131 + this.scroll, 158 - i * 7, 4 | 0x10);
        }
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < this.n[i]; ++j) {
                int m = this.cardNo(i, j);
                g.drawRegion(this.cards, (52 - m) * 21, 0, 21, 15, 0, 107 - j * 8 + this.scroll, 4 + i * 17, 0);
                if (j != this.s1y || i != this.s1x) continue;
                if (this.s1 == 0) {
                    g.setColor(0xFFFFFF);
                } else {
                    g.setColor(0xFF0000);
                }
                g.drawRect(114 - this.n[i] * 8 + this.scroll, 3 + this.s1x * 17, 14 + 8 * (this.n[i] - this.s1y), 16);
            }
        }
        if (this.s2x != -1) {
            g.setColor(0xFFFFFF);
            g.drawRect(114 - this.n[this.s2x] * 8 + this.scroll, 3 + this.s2x * 17, 14 + 8 * this.n[this.s2x], 16);
        }
    }

    public boolean saveGame(String filename) {
        boolean ret = false;
        StubFileWriter r = StubGetter.getFileWriter();
        try {
            if (r != null) {
                ret = this.saveGame(r.open(filename));
                r.close();
            }
        }
        catch (IOException iox) {
            ret = false;
        }
        return ret;
    }

    public boolean saveGame(BufDataOutputStream bos) {
        try {
            int j;
            int i;
            bos.writeByte(this.rest);
            bos.writeByte(this.frest);
            bos.writeByte(this.diff);
            bos.writeInt(this.moves);
            bos.writeInt(this.score);
            for (i = 0; i < 10; ++i) {
                bos.writeByte(this.n[i]);
                for (j = 0; j < this.n[i]; ++j) {
                    bos.writeByte(this.state[i][j]);
                }
            }
            if (!this.dyncards) {
                bos.writeByte(1);
                for (i = 0; i < 10; ++i) {
                    for (j = 0; j < 5; ++j) {
                        bos.writeByte(this.drawbuf[i][j]);
                    }
                }
            } else {
                bos.writeByte(0);
            }
            bos.writeByte(this.undoes);
            for (i = 0; i < this.undoes; ++i) {
                bos.writeByte(this.undo_from[i]);
                bos.writeByte(this.undo_to[i]);
                bos.writeByte(this.undo_n[i]);
            }
            bos.flush();
        }
        catch (IOException iox) {
            return false;
        }
        return true;
    }

    public boolean loadGame(String filename) {
        boolean ret = false;
        StubFileReader r = StubGetter.getFileReader();
        try {
            if (r != null) {
                ret = this.loadGame(r.open(filename));
                r.close();
            }
        }
        catch (IOException iox) {
            ret = false;
        }
        return ret;
    }

    public boolean loadGame(BufDataInputStream bis) {
        int i;
        try {
            int j;
            this.rest = bis.readByte();
            this.frest = bis.readByte();
            this.diff = bis.readByte();
            this.moves = bis.readInt();
            this.score = bis.readInt();
            for (i = 0; i < 104; ++i) {
                this.flags[i] = false;
            }
            for (i = 0; i < 10; ++i) {
                this.n[i] = bis.readByte();
                for (j = 0; j < this.n[i]; ++j) {
                    this.state[i][j] = bis.readByte();
                    if (this.state[i][j] > 0) {
                        this.flags[this.state[i][j] - 1] = true;
                        continue;
                    }
                    if (this.state[i][j] >= 0) continue;
                    this.flags[-this.state[i][j] - 1] = true;
                }
            }
            if (bis.readByte() > 0) {
                this.dyncards = false;
                for (i = 0; i < 10; ++i) {
                    for (j = 0; j < 5; ++j) {
                        this.drawbuf[i][j] = bis.readByte();
                    }
                }
            } else {
                this.dyncards = true;
            }
            this.mid.statdynCommand();
            this.undoes = bis.readByte();
            for (i = 0; i < this.undoes; ++i) {
                this.undo_from[i] = bis.readByte();
                this.undo_to[i] = bis.readByte();
                this.undo_n[i] = bis.readByte();
            }
        }
        catch (IOException e) {
            return false;
        }
        this.scroll = -10;
        this.s1x = 0;
        this.s1y = this.n[this.s1x] - 1;
        while (this.s1y > 0 && this.cardNo(this.s1x, this.s1y) == this.cardNo(this.s1x, this.s1y - 1) - 1 && (this.state[this.s1x][this.s1y] - 1) % 13 == (this.state[this.s1x][this.s1y - 1] - 1) % 13 - 1) {
            --this.s1y;
        }
        this.s2x = -1;
        this.s2y = 0;
        this.s2 = 0;
        this.s1 = 0;
        this.sing = 0;
        this.won = true;
        if (this.frest > 0) {
            this.won = false;
        }
        for (i = 0; i < 10; ++i) {
            if (this.n[i] == 0) continue;
            this.won = false;
            break;
        }
        this.repaint();
        return true;
    }

    boolean getHighscores(BufDataInputStream bis) {
        int r = 0;
        try {
            StringItem e = (StringItem)this.HSBox.get(0);
            StringItem m = (StringItem)this.HSBox.get(1);
            StringItem h = (StringItem)this.HSBox.get(2);
            r = bis.readInt();
            byte[] a = new byte[r];
            bis.read(a);
            e.setText(new String(a, "UTF-8"));
            r = bis.readInt();
            a = new byte[r];
            bis.read(a);
            m.setText(new String(a, "UTF-8"));
            r = bis.readInt();
            a = new byte[r];
            bis.read(a);
            h.setText(new String(a, "UTF-8"));
        }
        catch (IOException exx) {
            return false;
        }
        return true;
    }

    boolean putHighscores(BufDataOutputStream bos) {
        boolean r = false;
        try {
            StringItem e = (StringItem)this.HSBox.get(0);
            StringItem m = (StringItem)this.HSBox.get(1);
            StringItem h = (StringItem)this.HSBox.get(2);
            byte[] a = e.getText().getBytes("UTF-8");
            bos.writeInt(a.length);
            bos.write(a);
            a = m.getText().getBytes("UTF-8");
            bos.writeInt(a.length);
            bos.write(a);
            a = h.getText().getBytes("UTF-8");
            bos.writeInt(a.length);
            bos.write(a);
            bos.flush();
        }
        catch (IOException exx) {
            return false;
        }
        return true;
    }

    boolean loadHighscores() {
        try {
            RecordStore recs = RecordStore.openRecordStore((String)"SpiderHighscores", (boolean)false);
            RecordEnumeration en = recs.enumerateRecords(null, null, true);
            byte[] data = en.nextRecord();
            BufDataInputStream bis = new BufDataInputStream(2048, new ByteArrayInputStream(data));
            if (!this.getHighscores(bis)) {
                return false;
            }
            bis.close();
            recs.closeRecordStore();
        }
        catch (RecordStoreException rsx) {
            return false;
        }
        catch (IOException iox) {
            return false;
        }
        return true;
    }

    boolean saveHighscores() {
        try {
            RecordStore.deleteRecordStore((String)"SpiderHighscores");
        }
        catch (RecordStoreException rsx) {
            // empty catch block
        }
        try {
            RecordStore recs = RecordStore.openRecordStore((String)"SpiderHighscores", (boolean)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufDataOutputStream bos = new BufDataOutputStream(2048, baos);
            if (!this.putHighscores(bos)) {
                return false;
            }
            bos.flush();
            byte[] data = baos.toByteArray();
            recs.addRecord(data, 0, data.length);
            bos.close();
            recs.closeRecordStore();
        }
        catch (RecordStoreException rsx) {
            return false;
        }
        catch (IOException iox) {
            return false;
        }
        return true;
    }

    public void updateHighscores(String name) {
        String hs = ((StringItem)this.HSBox.get(this.diff)).getText();
        if (hs.length() == 0) {
            hs = name + ": " + String.valueOf(this.score);
        } else {
            int i;
            for (i = 0; i < hs.length() && (hs.charAt(i) < '0' || hs.charAt(i) > '9'); ++i) {
            }
            int os = 0;
            while (i < hs.length() && hs.charAt(i) >= '0' && hs.charAt(i) <= '9') {
                os = os * 10 + hs.charAt(i) - 48;
                ++i;
            }
            if (this.score > os) {
                hs = name + ": " + String.valueOf(this.score) + "\n" + hs;
            }
        }
        ((StringItem)this.HSBox.get(this.diff)).setText(hs);
        this.saveHighscores();
    }

    public void clearHighscores() {
        ((StringItem)this.HSBox.get(0)).setText("");
        ((StringItem)this.HSBox.get(1)).setText("");
        ((StringItem)this.HSBox.get(2)).setText("");
        this.saveHighscores();
    }

    protected void keyPressed(int keyCode) {
        int o1i = this.s1x;
        int o1j = this.s1y;
        int o2i = this.s2x;
        int o2j = this.s2y;
        if (this.won) {
            return;
        }
        if (keyCode == this.KEY_LEFT || keyCode == 52) {
            if (this.sing == 0 && this.s1y < this.n[this.s1x] - 1) {
                ++this.s1y;
            }
        } else if (keyCode == this.KEY_RIGHT || keyCode == 54) {
            if (this.sing == 0 && this.s1y > 0) {
                int nn = this.cardNo(this.s1x, this.s1y);
                int no = this.cardNo(this.s1x, this.s1y - 1);
                if (no != 0 && nn == no - 1 && (nn - 1) % 13 == (no - 1) % 13 - 1) {
                    --this.s1y;
                }
            }
        } else if (keyCode == this.KEY_UP || keyCode == 50) {
            if (this.sing == 0) {
                this.s1x = (this.s1x + 9) % 10;
                while (this.n[this.s1x] == 0) {
                    this.s1x = (this.s1x + 9) % 10;
                }
                this.s1y = this.n[this.s1x] - 1;
                while (this.s1y > 0 && this.cardNo(this.s1x, this.s1y) == this.cardNo(this.s1x, this.s1y - 1) - 1 && (this.state[this.s1x][this.s1y] - 1) % 13 == (this.state[this.s1x][this.s1y - 1] - 1) % 13 - 1) {
                    --this.s1y;
                }
            } else if (this.sing == 1) {
                this.s2x = (this.s2x + 9) % 10;
            }
        } else if (keyCode == this.KEY_DOWN || keyCode == 56) {
            if (this.sing == 0) {
                this.s1x = (this.s1x + 1) % 10;
                while (this.n[this.s1x] == 0) {
                    this.s1x = (this.s1x + 1) % 10;
                }
                this.s1y = this.n[this.s1x] - 1;
                while (this.s1y > 0 && this.cardNo(this.s1x, this.s1y) == this.cardNo(this.s1x, this.s1y - 1) - 1 && (this.state[this.s1x][this.s1y] - 1) % 13 == (this.state[this.s1x][this.s1y - 1] - 1) % 13 - 1) {
                    --this.s1y;
                }
            } else if (this.sing == 1) {
                this.s2x = (this.s2x + 1) % 10;
            }
        } else if (keyCode == this.KEY_FIRE || keyCode == 53) {
            if (this.sing == 0) {
                this.sing = 1;
                this.s1 = 1;
                this.s2x = this.s1x;
            } else if (this.sing == 1) {
                int nn = 0;
                int no = 0;
                if (this.n[this.s2x] != 0) {
                    nn = this.state[this.s2x][this.n[this.s2x] - 1];
                    no = this.state[this.s1x][this.s1y];
                    nn = nn > 0 ? (nn - 1) % 13 + 1 : 0;
                    no = no > 0 ? (no - 1) % 13 + 1 : 0;
                }
                if (nn == 0 || no == nn - 1) {
                    ++this.moves;
                    --this.score;
                    this.undoPush(this.s1x, this.s2x, this.n[this.s1x] - this.s1y);
                    for (int i = this.n[this.s2x]; i < this.n[this.s2x] + this.n[this.s1x] - this.s1y; ++i) {
                        this.state[this.s2x][i] = this.state[this.s1x][i - this.n[this.s2x] + this.s1y];
                    }
                    int n = this.s2x;
                    this.n[n] = this.n[n] + (this.n[this.s1x] - this.s1y);
                    this.n[this.s1x] = this.s1y;
                    if (this.n[this.s2x] >= 13) {
                        int j = 1;
                        int i = this.n[this.s2x] - 1;
                        while (i > 0 && this.state[this.s2x][i - 1] > 0 && this.cardNo(this.s2x, i) == this.cardNo(this.s2x, i - 1) - 1 && (this.state[this.s2x][i] - 1) % 13 == (this.state[this.s2x][i - 1] - 1) % 13 - 1) {
                            --i;
                            ++j;
                        }
                        if (j >= 13) {
                            int n2 = this.s2x;
                            this.n[n2] = this.n[n2] - 13;
                            if (this.n[this.s2x] > 0 && this.state[this.s2x][this.n[this.s2x] - 1] <= 0) {
                                this.state[this.s2x][this.n[this.s2x] - 1] = this.openCard(this.state[this.s2x][this.n[this.s2x] - 1]);
                            }
                            this.score += 100;
                            this.undoClear();
                        }
                    }
                    if (this.n[this.s1x] > 0 && this.state[this.s1x][this.n[this.s1x] - 1] <= 0) {
                        this.state[this.s1x][this.n[this.s1x] - 1] = this.openCard(this.state[this.s1x][this.n[this.s1x] - 1]);
                        this.undoSetFlag(true);
                    } else {
                        this.undoSetFlag(false);
                    }
                    this.sing = 0;
                    this.s1 = 0;
                    this.s2 = 0;
                    this.s1x = this.s2x;
                    this.s2x = -1;
                    this.s2y = -1;
                    if (this.n[this.s1x] == 0) {
                        this.s1x = 0;
                        while (this.s1x < 10 && this.n[this.s1x] <= 0) {
                            ++this.s1x;
                        }
                        if (this.s1x > 9) {
                            this.s1x = 0;
                            this.won = true;
                            if (this.frest > 0) {
                                this.won = false;
                            }
                        }
                    }
                    if (!this.won) {
                        this.s1y = this.n[this.s1x] - 1;
                        while (this.s1y > 0 && this.cardNo(this.s1x, this.s1y) == this.cardNo(this.s1x, this.s1y - 1) - 1 && (this.state[this.s1x][this.s1y] - 1) % 13 == (this.state[this.s1x][this.s1y - 1] - 1) % 13 - 1) {
                            --this.s1y;
                        }
                    }
                    this.repaint();
                }
            }
        } else if (keyCode == 48) {
            if (this.sing == 1) {
                this.sing = 0;
                this.s1x = this.s2x;
                this.s2x = -1;
                this.s2y = -1;
                this.s2 = 0;
                this.s1 = 0;
                if (this.n[this.s1x] == 0) {
                    this.s1x = 0;
                    while (this.n[this.s1x] == 0) {
                        ++this.s1x;
                    }
                }
                this.s1y = this.n[this.s1x] - 1;
                while (this.s1y > 0 && this.cardNo(this.s1x, this.s1y) == this.cardNo(this.s1x, this.s1y - 1) - 1 && (this.state[this.s1x][this.s1y] - 1) % 13 == (this.state[this.s1x][this.s1y - 1] - 1) % 13 - 1) {
                    --this.s1y;
                }
            }
        } else if (keyCode == 42 || keyCode == 35) {
            if (keyCode == 42) {
                this.pSTAR = true;
            } else {
                this.pPOUND = true;
            }
            if (this.pSTAR && this.pPOUND && this.frest > 0) {
                int k;
                this.undoClear();
                for (k = 0; k < 10; ++k) {
                    this.state[k][this.n[k]] = this.openCard(this.drawbuf[k][this.frest - 1]);
                    int n = k;
                    this.n[n] = this.n[n] + 1;
                    if (this.n[k] < 13) continue;
                    int j = 1;
                    int i = this.n[k] - 1;
                    while (i > 0 && this.state[k][i - 1] > 0 && this.cardNo(k, i) == this.cardNo(k, i - 1) - 1 && (this.state[k][i] - 1) % 13 == (this.state[k][i - 1] - 1) % 13 - 1) {
                        --i;
                        ++j;
                    }
                    if (j < 13) continue;
                    int n3 = k;
                    this.n[n3] = this.n[n3] - 13;
                    if (this.n[k] > 0 && this.state[k][this.n[k] - 1] <= 0) {
                        this.state[k][this.n[k] - 1] = this.openCard(this.state[k][this.n[k] - 1]);
                    }
                    this.score += 100;
                    this.undoClear();
                }
                for (k = 0; k < 10 && this.n[k] <= 0; ++k) {
                }
                this.won = k > 9 && this.frest == 0;
                this.sing = 0;
                this.s2x = -1;
                this.s2y = -1;
                this.s1 = 0;
                this.s2 = 0;
                this.s1y = this.n[this.s1x] - 1;
                while (this.s1y > 0 && this.cardNo(this.s1x, this.s1y) == this.cardNo(this.s1x, this.s1y - 1) - 1 && (this.state[this.s1x][this.s1y] - 1) % 13 == (this.state[this.s1x][this.s1y - 1] - 1) % 13 - 1) {
                    --this.s1y;
                }
                --this.frest;
                this.repaint();
            }
        } else if (keyCode == 49 || keyCode == 55) {
            this.scroll += 50;
            this.repaint();
        } else if (keyCode == 51 || keyCode == 57) {
            this.scroll -= 50;
            this.repaint();
        }
        if (this.s1x != o1i || this.s1y != o1j || this.s2x != o2i || this.s2y != o2j) {
            this.repaint();
        }
    }

    protected void keyReleased(int keyCode) {
        if (keyCode == 42) {
            this.pSTAR = false;
        } else if (keyCode == 35) {
            this.pPOUND = false;
        }
    }

    protected void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }
}

