/*
 * Decompiled with CFR 0.152.
 */
import com.vmx.BufDataInputStream;
import com.vmx.BufDataOutputStream;
import com.vmx.StubFileReader;
import com.vmx.StubFileWriter;
import com.vmx.StubGetter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class vsCanvas
extends Canvas {
    vsMIDlet vsm;
    Timer tmr;
    vsTTMovement ttm;
    vsTTApples tta;
    StubFileReader stubreader;
    StubFileWriter stubwriter;
    public int Cw = 8;
    public int Ch = 8;
    public int Mr = 100;
    public int Ar = 2000;
    public int Gr = 1;
    public int backColor = 0;
    public int snakeHeadColor = 57344;
    public int snakeBodyColor = 24576;
    public int appleColor = 0xFF8080;
    public int fontColor = 0xFFFFFF;
    public int score;
    int oscore;
    Image tilesSrc;
    Image tiles;
    Image fontSrc;
    Image font;
    Image diffies;
    Image nogameImg;
    Image gameoverImg;
    Image backImg;
    int Fw;
    int Fh;
    int w;
    int h;
    int sx;
    int sy;
    Random rng;
    int[] field;
    int[] fdir;
    int shx;
    int shy;
    int stx;
    int sty;
    int oshx;
    int oshy;
    int ostx;
    int osty;
    boolean moving;
    int growing;
    int paused;
    boolean gameover;
    int mode;
    int oldmode;
    int cdiffy;
    int diffyw;
    int diffyh;
    final int[] Di;
    final int[] Da;
    Font mfnt;
    int KEY_LEFT;
    int KEY_RIGHT;
    int KEY_UP;
    int KEY_DOWN;
    int KEY_FIRE;
    public String[] highscoreNames = null;
    public int[] highscoreValues = null;
    public int[] highscoreMultiplies = null;

    public vsCanvas(vsMIDlet mid) {
        if (!this.loadSettings()) {
            this.saveSettings();
        }
        this.loadHighscores();
        try {
            this.fontSrc = Image.createImage((String)"/font.png");
        }
        catch (IOException iox) {
            this.fontSrc = null;
        }
        try {
            this.diffies = Image.createImage((String)"/diff.png");
        }
        catch (IOException iox) {
            this.diffies = null;
        }
        this.diffyw = this.diffies.getWidth();
        this.diffyh = this.diffies.getHeight() / 8;
        this.Di = new int[8];
        this.Di[0] = 25;
        this.Di[1] = 50;
        this.Di[2] = 75;
        this.Di[3] = 100;
        this.Di[4] = 150;
        this.Di[5] = 200;
        this.Di[6] = 250;
        this.Di[7] = 300;
        this.Da = new int[8];
        this.Da[0] = 500;
        this.Da[1] = 1000;
        this.Da[2] = 2000;
        this.Da[3] = 3000;
        this.Da[4] = 4000;
        this.Da[5] = 5000;
        this.Da[6] = 6000;
        this.Da[7] = 7000;
        try {
            this.gameoverImg = Image.createImage((String)"/gameover.png");
        }
        catch (IOException iox) {
            this.gameoverImg = null;
        }
        try {
            this.nogameImg = Image.createImage((String)"/nogame.png");
        }
        catch (IOException iox) {
            this.nogameImg = null;
        }
        try {
            this.backImg = Image.createImage((String)"/back.png");
        }
        catch (IOException iox) {
            this.backImg = null;
        }
        this.Fh = 0;
        this.Fw = 0;
        this.buildTiles();
        this.buildFont();
        this.mfnt = Font.getFont((int)0, (int)1, (int)0);
        this.KEY_LEFT = this.getKeyCode(2);
        this.KEY_RIGHT = this.getKeyCode(5);
        this.KEY_DOWN = this.getKeyCode(6);
        this.KEY_UP = this.getKeyCode(1);
        this.KEY_FIRE = this.getKeyCode(8);
        this.setFullScreenMode(true);
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.sx = this.w / this.Cw;
        this.sy = (this.h - this.Fh - 1) / this.Ch;
        this.field = null;
        this.fdir = null;
        this.rng = new Random();
        this.vsm = mid;
        this.tmr = new Timer();
        this.ttm = null;
        this.mode = 0;
        this.stubreader = StubGetter.getFileReader();
        this.stubwriter = StubGetter.getFileWriter();
        this.addCommand(new Command(this.vsm.CommandST[0], 1, 1));
        this.addCommand(new Command(this.vsm.CommandST[1], 1, 1));
        if (this.stubreader != null) {
            this.addCommand(new Command(this.vsm.CommandST[2], 1, 1));
        }
        this.addCommand(new Command(this.vsm.CommandST[3], 1, 1));
        this.addCommand(new Command(this.vsm.CommandST[4], 1, 1));
        this.addCommand(new Command(this.vsm.CommandST[5], 1, 1));
        this.addCommand(new Command(this.vsm.CommandST[19], 1, 1));
        this.addCommand(new Command(this.vsm.CommandST[13], 1, 1));
        if (this.stubwriter != null) {
            this.addCommand(new Command(this.vsm.CommandST[6], 1, 1));
        }
        this.addCommand(new Command(this.vsm.CommandST[7], 1, 1));
        this.addCommand(new Command(this.vsm.CommandST[8], 7, 1));
        this.setCommandListener(this.vsm);
    }

    public boolean clearHighscores() {
        this.highscoreNames = null;
        this.highscoreValues = null;
        try {
            RecordStore.deleteRecordStore((String)"SnakeHighscores");
        }
        catch (RecordStoreException rsx) {
            return false;
        }
        return true;
    }

    public boolean addHighscore(String name) {
        try {
            RecordStore recs = RecordStore.openRecordStore((String)"SnakeHighscores", (boolean)true);
            byte[] data = (name + "\n" + Integer.toString(this.score) + "\n" + Integer.toString(1000 / this.Mr)).getBytes("UTF-8");
            recs.addRecord(data, 0, data.length);
            recs.closeRecordStore();
            String[] ohn = this.highscoreNames;
            int[] ohv = this.highscoreValues;
            int[] ohm = this.highscoreMultiplies;
            int n = 0;
            if (this.highscoreNames != null) {
                n = this.highscoreNames.length;
            }
            this.highscoreNames = new String[n + 1];
            this.highscoreValues = new int[n + 1];
            this.highscoreMultiplies = new int[n + 1];
            for (int i = 0; i < n; ++i) {
                this.highscoreNames[i] = ohn[i];
                this.highscoreValues[i] = ohv[i];
                this.highscoreMultiplies[i] = ohm[i];
            }
            this.highscoreNames[n] = name;
            this.highscoreValues[n] = this.score;
            this.highscoreMultiplies[n] = 1000 / this.Mr;
        }
        catch (RecordStoreException rsx) {
            return false;
        }
        catch (Exception x) {
            return false;
        }
        return true;
    }

    public boolean loadHighscores() {
        try {
            RecordStore recs = RecordStore.openRecordStore((String)"SnakeHighscores", (boolean)false);
            RecordEnumeration en = recs.enumerateRecords(null, null, true);
            int n = en.numRecords();
            this.highscoreNames = new String[n];
            this.highscoreValues = new int[n];
            this.highscoreMultiplies = new int[n];
            for (int i = 0; i < n; ++i) {
                byte[] data = en.nextRecord();
                String hs = new String(data, "UTF-8");
                int j = hs.indexOf("\n");
                this.highscoreNames[i] = hs.substring(0, j);
                hs = hs.substring(j + 1);
                j = hs.indexOf("\n");
                this.highscoreValues[i] = Integer.parseInt(hs.substring(0, j));
                this.highscoreMultiplies[i] = Integer.parseInt(hs.substring(j + 1));
            }
            recs.closeRecordStore();
        }
        catch (RecordStoreException rsx) {
            return false;
        }
        catch (IOException iox) {
            return false;
        }
        return true;
    }

    public boolean saveHighscores() {
        try {
            RecordStore.deleteRecordStore((String)"SnakeHighscores");
        }
        catch (RecordStoreException rsx) {
            // empty catch block
        }
        try {
            RecordStore recs = RecordStore.openRecordStore((String)"SnakeHighscores", (boolean)true);
            if (this.highscoreNames != null) {
                int n = this.highscoreNames.length;
                for (int i = 0; i < n; ++i) {
                    byte[] data = (this.highscoreNames[i] + "\n" + Integer.toString(this.highscoreValues[i]) + "\n" + Integer.toString(this.highscoreMultiplies[i])).getBytes("UTF-8");
                    recs.addRecord(data, 0, data.length);
                }
            }
            recs.closeRecordStore();
        }
        catch (RecordStoreException rsx) {
            return false;
        }
        catch (IOException iox) {
            return false;
        }
        return true;
    }

    public boolean loadSettings() {
        try {
            RecordStore recs = RecordStore.openRecordStore((String)"SnakeSettings", (boolean)false);
            RecordEnumeration en = recs.enumerateRecords(null, null, true);
            byte[] data = en.nextRecord();
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(is);
            this.Cw = dis.readInt();
            this.Ch = dis.readInt();
            this.Mr = dis.readInt();
            this.Ar = dis.readInt();
            this.Gr = dis.readInt();
            this.backColor = dis.readInt();
            this.snakeHeadColor = dis.readInt();
            this.snakeBodyColor = dis.readInt();
            this.appleColor = dis.readInt();
            this.fontColor = dis.readInt();
            dis.close();
            recs.closeRecordStore();
        }
        catch (RecordStoreException rsx) {
            return false;
        }
        catch (IOException iox) {
            return false;
        }
        return true;
    }

    public boolean saveSettings() {
        try {
            RecordStore.deleteRecordStore((String)"SnakeSettings");
        }
        catch (RecordStoreException rsx) {
            // empty catch block
        }
        try {
            RecordStore recs = RecordStore.openRecordStore((String)"SnakeSettings", (boolean)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(this.Cw);
            dos.writeInt(this.Ch);
            dos.writeInt(this.Mr);
            dos.writeInt(this.Ar);
            dos.writeInt(this.Gr);
            dos.writeInt(this.backColor);
            dos.writeInt(this.snakeHeadColor);
            dos.writeInt(this.snakeBodyColor);
            dos.writeInt(this.appleColor);
            dos.writeInt(this.fontColor);
            dos.flush();
            byte[] data = baos.toByteArray();
            recs.addRecord(data, 0, data.length);
            dos.close();
            recs.closeRecordStore();
        }
        catch (RecordStoreException rsx) {
            return false;
        }
        catch (IOException iox) {
            return false;
        }
        return true;
    }

    public boolean loadGame() {
        try {
            RecordStore recs = RecordStore.openRecordStore((String)"SnakeGame", (boolean)false);
            RecordEnumeration en = recs.enumerateRecords(null, null, true);
            byte[] data = en.nextRecord();
            BufDataInputStream dis = new BufDataInputStream(2048, new ByteArrayInputStream(data));
            if (!this.loadGame(dis)) {
                return false;
            }
            dis.close();
            recs.closeRecordStore();
        }
        catch (RecordStoreException rsx) {
            return false;
        }
        catch (IOException iox) {
            return false;
        }
        return true;
    }

    public boolean saveGame() {
        try {
            RecordStore.deleteRecordStore((String)"SnakeGame");
        }
        catch (RecordStoreException rsx) {
            // empty catch block
        }
        try {
            RecordStore recs = RecordStore.openRecordStore((String)"SnakeGame", (boolean)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufDataOutputStream bdos = new BufDataOutputStream(2048, baos);
            if (!this.saveGame(bdos)) {
                return false;
            }
            byte[] data = baos.toByteArray();
            recs.addRecord(data, 0, data.length);
            bdos.close();
            recs.closeRecordStore();
        }
        catch (RecordStoreException rsx) {
            return false;
        }
        catch (IOException iox) {
            return false;
        }
        return true;
    }

    public boolean loadGame(BufDataInputStream dis) {
        if (this.paused == 0) {
            this.paused = 1;
        }
        try {
            this.Cw = dis.readInt();
            this.Ch = dis.readInt();
            this.Mr = dis.readInt();
            this.Ar = dis.readInt();
            this.Gr = dis.readInt();
            this.backColor = dis.readInt();
            this.snakeHeadColor = dis.readInt();
            this.snakeBodyColor = dis.readInt();
            this.appleColor = dis.readInt();
            this.fontColor = dis.readInt();
            this.oscore = this.score = dis.readInt();
            this.oshx = this.shx = dis.readInt();
            this.oshy = this.shy = dis.readInt();
            this.ostx = this.stx = dis.readInt();
            this.osty = this.sty = dis.readInt();
            this.sx = dis.readInt();
            this.sy = dis.readInt();
            this.field = new int[this.sx * this.sy];
            this.fdir = new int[this.sx * this.sy];
            for (int i = 0; i < this.sx * this.sy; ++i) {
                this.field[i] = dis.readInt();
                this.fdir[i] = dis.readInt();
            }
            this.gameover = false;
            this.mode = 1;
        }
        catch (IOException iox) {
            return false;
        }
        return true;
    }

    public boolean saveGame(BufDataOutputStream dos) {
        if (this.gameover) {
            return false;
        }
        try {
            dos.writeInt(this.Cw);
            dos.writeInt(this.Ch);
            dos.writeInt(this.Mr);
            dos.writeInt(this.Ar);
            dos.writeInt(this.Gr);
            dos.writeInt(this.backColor);
            dos.writeInt(this.snakeHeadColor);
            dos.writeInt(this.snakeBodyColor);
            dos.writeInt(this.appleColor);
            dos.writeInt(this.fontColor);
            dos.writeInt(this.score);
            dos.writeInt(this.shx);
            dos.writeInt(this.shy);
            dos.writeInt(this.stx);
            dos.writeInt(this.sty);
            dos.writeInt(this.sx);
            dos.writeInt(this.sy);
            for (int i = 0; i < this.sx * this.sy; ++i) {
                dos.writeInt(this.field[i]);
                dos.writeInt(this.fdir[i]);
            }
            dos.flush();
        }
        catch (IOException iox) {
            return false;
        }
        return true;
    }

    public boolean loadGame(String filename) {
        boolean r = false;
        if (this.stubreader != null) {
            try {
                BufDataInputStream bdis = this.stubreader.open(filename);
                if (this.loadGame(bdis)) {
                    r = true;
                }
                this.stubreader.close();
            }
            catch (IOException iox) {
                return false;
            }
        }
        return r;
    }

    public boolean saveGame(String filename) {
        boolean r = false;
        if (this.stubwriter != null) {
            try {
                BufDataOutputStream bdos = this.stubwriter.open(filename);
                if (this.saveGame(bdos)) {
                    r = true;
                }
                this.stubwriter.close();
            }
            catch (IOException iox) {
                return false;
            }
        }
        return r;
    }

    public void applySettings() {
        this.buildTiles();
        this.buildFont();
        this.saveSettings();
    }

    public void buildTiles() {
        try {
            this.tilesSrc = Image.createImage((String)("/tiles" + Integer.toString(this.Cw) + "x" + Integer.toString(this.Ch) + ".png"));
        }
        catch (IOException iox) {
            this.tilesSrc = null;
        }
        if (this.tilesSrc == null || this.tilesSrc.getWidth() != 4 * this.Cw || this.tilesSrc.getHeight() != 6 * this.Ch) {
            this.tiles = null;
            return;
        }
        int[] rgbData = new int[24 * this.Cw * this.Ch];
        this.tilesSrc.getRGB(rgbData, 0, 4 * this.Cw, 0, 0, 4 * this.Cw, 6 * this.Ch);
        for (int k = 0; k < 6; ++k) {
            for (int l = 0; l < 4; ++l) {
                for (int i = 0; i < this.Ch; ++i) {
                    for (int j = 0; j < this.Cw; ++j) {
                        int a = rgbData[(k * this.Ch + i) * 4 * this.Cw + l * this.Cw + j];
                        if ((a >> 24 & 0xFF) != 255) continue;
                        if ((a & 0xFFFFFF) == 0) {
                            a = l != k - 2 ? this.snakeBodyColor | 0xFF000000 : this.appleColor | 0xFF000000;
                        } else if ((a & 0xFF) >= 240 && (a >> 8 & 0xFF) >= 240 && (a >> 16 & 0xFF) >= 240) {
                            a = this.snakeHeadColor | 0xFF000000;
                        }
                        rgbData[(k * this.Ch + i) * 4 * this.Cw + l * this.Cw + j] = a;
                    }
                }
            }
        }
        this.tiles = Image.createRGBImage((int[])rgbData, (int)32, (int)48, (boolean)true);
    }

    public void buildFont() {
        if (this.fontSrc == null) {
            this.font = null;
        }
        int w = this.fontSrc.getWidth();
        int h = this.fontSrc.getHeight();
        int[] rgbData = new int[w * h];
        this.fontSrc.getRGB(rgbData, 0, w, 0, 0, w, h);
        for (int i = 0; i < w * h; ++i) {
            if ((rgbData[i] >> 24 & 0xFF) != 255) continue;
            rgbData[i] = this.fontColor | 0xFF000000;
        }
        this.font = Image.createRGBImage((int[])rgbData, (int)w, (int)h, (boolean)true);
        this.Fw = w / 10;
        this.Fh = h;
    }

    public void outNumberRAlign(Graphics g, int num, int rx, int y) {
        int dm;
        int rnf = 0;
        for (dm = 1; dm < dm * 10 && num >= dm; dm *= 10) {
            ++rnf;
        }
        dm = 1;
        int i = rnf - 1;
        while (i >= 0) {
            int n = num / dm % 10;
            g.drawRegion(this.font, n * this.Fw, 0, this.Fw, this.Fh, 0, rx - (this.Fw + 1) * (rnf - i) + 1, y, 4 | 0x10);
            --i;
            dm *= 10;
        }
    }

    public void outNumberLAlign(Graphics g, int num, int lx, int y) {
        int dm;
        int rnf = 0;
        for (dm = 1; dm < dm * 10 && num >= dm; dm *= 10) {
            ++rnf;
        }
        dm = 1;
        int i = rnf - 1;
        while (i >= 0) {
            int n = num / dm % 10;
            g.drawRegion(this.font, n * this.Fw, 0, this.Fw, this.Fh, 0, lx + (this.Fw + 1) * i, y, 4 | 0x10);
            --i;
            dm *= 10;
        }
    }

    public void startGame() {
        this.mode = 1;
        this.sx = this.w / this.Cw;
        this.sy = (this.h - this.Fh - 1) / this.Ch;
        if (this.sy < 3) {
            return;
        }
        this.field = new int[this.sx * this.sy];
        this.fdir = new int[this.sx * this.sy];
        for (int i = 0; i < this.sx * this.sy; ++i) {
            this.field[i] = 0;
            this.fdir[i] = 0;
        }
        this.oshx = this.shx = this.sx / 2;
        this.oshy = this.shy = this.sy / 2 - 1;
        this.field[this.sx * (this.sy / 2) + this.sx / 2 - this.sx] = 1;
        this.field[this.sx * (this.sy / 2) + this.sx / 2] = 2;
        this.field[this.sx * (this.sy / 2) + this.sx / 2 + this.sx] = 3;
        this.fdir[this.sx * (this.sy / 2) + this.sx / 2 - this.sx] = 36;
        this.fdir[this.sx * (this.sy / 2) + this.sx / 2] = 36;
        this.fdir[this.sx * (this.sy / 2) + this.sx / 2 + this.sx] = 36;
        this.ostx = this.stx = this.sx / 2;
        this.osty = this.sty = this.sy / 2 + 1;
        this.growing = 0;
        this.score = 0;
        this.paused = 0;
        this.gameover = false;
        this.repaint();
        if (this.ttm != null) {
            this.ttm.cancel();
        }
        if (this.tta != null) {
            this.tta.cancel();
        }
        this.ttm = new vsTTMovement(this);
        this.tta = new vsTTApples(this);
        this.tmr.scheduleAtFixedRate((TimerTask)this.ttm, 0L, (long)this.Mr);
        this.tmr.scheduleAtFixedRate((TimerTask)this.tta, 0L, (long)this.Ar);
    }

    public void pauseGame() {
        if (this.gameover) {
            return;
        }
        ++this.paused;
        if (this.ttm != null) {
            this.ttm.cancel();
            this.ttm = null;
        }
        if (this.tta != null) {
            this.tta.cancel();
            this.tta.cancel();
        }
    }

    public void resumeGame() {
        if (this.gameover) {
            return;
        }
        if (this.paused > 0) {
            --this.paused;
        }
        if (this.paused == 0 && (this.ttm == null || this.tta == null)) {
            this.ttm = new vsTTMovement(this);
            this.tta = new vsTTApples(this);
            this.tmr.scheduleAtFixedRate((TimerTask)this.ttm, 0L, (long)this.Mr);
            this.tmr.scheduleAtFixedRate((TimerTask)this.tta, 0L, (long)this.Ar);
        }
    }

    public void pauseResume() {
        if (this.paused > 0) {
            this.resumeGame();
        } else {
            this.pauseGame();
        }
    }

    public void gameOver() {
        this.gameover = true;
        this.paused = 0;
        this.mode = 2;
        if (this.ttm != null) {
            this.ttm.cancel();
            this.ttm = null;
        }
        if (this.tta != null) {
            this.tta.cancel();
            this.tta.cancel();
        }
        this.repaint();
    }

    public void endGame() {
        this.gameOver();
        this.field = null;
        this.fdir = null;
    }

    public int getNextx(int x, int dir) {
        if (dir == 1) {
            --x;
        } else if (dir == 3) {
            ++x;
        }
        x = (x + this.sx) % this.sx;
        return x;
    }

    public int getNexty(int y, int dir) {
        if (dir == 2) {
            --y;
        } else if (dir == 4) {
            ++y;
        }
        y = (y + this.sy) % this.sy;
        return y;
    }

    public int negateDir(int dir) {
        if (dir == 1) {
            return 3;
        }
        if (dir == 2) {
            return 4;
        }
        if (dir == 3) {
            return 1;
        }
        if (dir == 4) {
            return 2;
        }
        return 0;
    }

    public void moveSnake() {
        if (this.field == null || this.fdir == null) {
            return;
        }
        this.ostx = this.stx;
        this.osty = this.sty;
        this.oshx = this.shx;
        this.oshy = this.shy;
        this.oscore = this.score;
        this.moving = true;
        int dir = this.fdir[this.shy * this.sx + this.shx] >> 4;
        int nextx = this.getNextx(this.shx, dir);
        int nexty = this.getNexty(this.shy, dir);
        if (this.field[nexty * this.sx + nextx] > 0) {
            if (this.field[nexty * this.sx + nextx] == 4) {
                this.growing = this.Gr;
            } else {
                this.field[nexty * this.sx + nextx] = 1;
                this.fdir[nexty * this.sx + nextx] = this.negateDir(dir) | dir << 4;
                this.field[this.shy * this.sx + this.shx] = 2;
                this.moving = false;
                this.gameOver();
            }
        }
        this.field[nexty * this.sx + nextx] = 1;
        this.fdir[nexty * this.sx + nextx] = this.negateDir(dir) | dir << 4;
        this.field[this.shy * this.sx + this.shx] = 2;
        this.shx = nextx;
        this.shy = nexty;
        if (this.growing == 0) {
            dir = this.fdir[this.sty * this.sx + this.stx] >> 4;
            nextx = this.getNextx(this.stx, dir);
            nexty = this.getNexty(this.sty, dir);
            this.field[this.sty * this.sx + this.stx] = 0;
            this.field[nexty * this.sx + nextx] = 3;
            this.stx = nextx;
            this.sty = nexty;
        } else {
            --this.growing;
            this.score += 1000 / this.Mr;
        }
        this.moving = false;
    }

    public void putApple() {
        int ran;
        if (this.field == null || this.fdir == null || this.moving) {
            return;
        }
        int sxy = this.sx * this.sy;
        int rano = ran = this.rng.nextInt(sxy);
        if (this.field[ran] != 0) {
            while (this.field[ran = (ran + 1) % sxy] != 0 && ran != rano) {
            }
            if (ran == rano) {
                this.gameOver();
            }
        }
        int ax = ran % this.sx;
        int ay = ran % this.sy;
        this.field[ran] = 4;
        this.repaint();
    }

    public void paintGame(Graphics g) {
        if (this.tiles != null) {
            int n = 0;
            for (int i = 0; i < this.sy; ++i) {
                int j = 0;
                while (j < this.sx) {
                    switch (this.field[n]) {
                        case 1: {
                            g.drawRegion(this.tiles, (this.negateDir(this.fdir[this.shy * this.sx + this.shx] & 0xF) - 1) * this.Cw, 0, this.Cw, this.Ch, 0, this.Cw * j, this.Ch * i, 20);
                            break;
                        }
                        case 2: {
                            g.drawRegion(this.tiles, ((this.fdir[n] >> 4) - 1) * this.Cw, this.Ch * ((this.fdir[n] & 0xF) + 1), this.Cw, this.Ch, 0, this.Cw * j, this.Ch * i, 20);
                            break;
                        }
                        case 3: {
                            g.drawRegion(this.tiles, ((this.fdir[this.sty * this.sx + this.stx] >> 4) - 1) * this.Cw, this.Ch, this.Cw, this.Ch, 0, this.Cw * j, this.Ch * i, 20);
                            break;
                        }
                        case 4: {
                            g.drawRegion(this.tiles, 0, this.Ch * 2, this.Cw, this.Ch, 0, this.Cw * j, this.Ch * i, 20);
                        }
                    }
                    ++j;
                    ++n;
                }
            }
        } else {
            int n = 0;
            for (int i = 0; i < this.sy; ++i) {
                int j = 0;
                while (j < this.sx) {
                    if (this.field[n] > 0) {
                        if (this.field[n] == 1) {
                            g.setColor(this.snakeHeadColor);
                        } else if (this.field[n] == 4) {
                            g.setColor(this.appleColor);
                        } else {
                            g.setColor(this.snakeBodyColor);
                        }
                        g.fillRect(this.Cw * j, this.Ch * i, this.Cw, this.Ch);
                    }
                    ++j;
                    ++n;
                }
            }
        }
        if (this.font != null) {
            this.outNumberRAlign(g, this.score, this.w, this.h - this.Fh);
        }
    }

    public void paintNoGame(Graphics g) {
        if (this.nogameImg == null) {
            g.setColor(this.fontColor);
            g.drawString(this.vsm.CommandST[9], this.w / 2, 1, 1 | 0x10);
        } else {
            g.drawImage(this.nogameImg, this.w / 2, this.h / 2, 1 | 2);
        }
    }

    public void paintGameOver(Graphics g) {
        this.paintGame(g);
        if (this.gameoverImg == null) {
            g.setColor(this.fontColor);
            g.drawString(this.vsm.CommandST[10], this.w / 2, 1, 1 | 0x10);
        } else {
            g.drawImage(this.gameoverImg, this.w / 2, this.h / 2, 1 | 2);
        }
    }

    public void paintDiffy(Graphics g) {
        if (this.mode == 3) {
            g.setColor(this.fontColor);
            this.outNumberLAlign(g, this.Di[this.cdiffy], 0, 0);
            g.drawString(this.vsm.CommandST[11], this.w / 2, this.h, 0x20 | 1);
        } else if (this.mode == 4) {
            g.setColor(this.fontColor);
            this.outNumberLAlign(g, this.Da[this.cdiffy], 0, 0);
            g.drawString(this.vsm.CommandST[12], this.w / 2, this.h, 0x20 | 1);
        }
        if (this.diffies != null) {
            g.drawRegion(this.diffies, 0, this.diffyh * (7 - this.cdiffy), this.diffyw, this.diffyh, 0, this.w / 2, this.Fh + 1, 1 | 0x10);
        }
    }

    public void paint(Graphics g) {
        g.setColor(this.backColor);
        g.fillRect(0, 0, this.w, this.h);
        if (this.backImg != null) {
            g.drawImage(this.backImg, this.w / 2, this.h / 2, 1 | 2);
        }
        g.setFont(this.mfnt);
        if (this.mode == 3 || this.mode == 4) {
            this.paintDiffy(g);
        } else if (this.mode == 0 || this.field == null || this.Ch < 1 || this.Cw < 1) {
            this.paintNoGame(g);
        } else if (this.mode == 1) {
            this.paintGame(g);
        } else if (this.mode == 2) {
            this.paintGameOver(g);
        }
    }

    public void loadDiffy(int[] D, int p) {
        this.cdiffy = D.length - 1;
        for (int i = 0; i < D.length; ++i) {
            if (p > D[i]) continue;
            this.cdiffy = i;
            break;
        }
    }

    public void saveDiffyMr() {
        this.Mr = this.Di[this.cdiffy];
        this.saveSettings();
    }

    public void saveDiffyAr() {
        this.Ar = this.Da[this.cdiffy];
        this.saveSettings();
    }

    public void repaintSnake() {
        int l1 = this.shx;
        int r1 = this.shx + 1;
        int t1 = this.shy;
        int b1 = this.shy + 1;
        if (l1 > this.oshx) {
            l1 = this.oshx;
        }
        if (r1 < this.oshx + 1) {
            r1 = this.oshx + 1;
        }
        if (t1 > this.oshy) {
            t1 = this.oshy;
        }
        if (b1 < this.oshy + 1) {
            b1 = this.oshy + 1;
        }
        this.repaint(l1 * this.Cw, t1 * this.Ch, (r1 - l1) * this.Cw, (b1 - t1) * this.Ch);
        l1 = this.stx;
        r1 = this.stx + 1;
        t1 = this.sty;
        b1 = this.sty + 1;
        if (l1 > this.ostx) {
            l1 = this.ostx;
        }
        if (r1 < this.ostx + 1) {
            r1 = this.ostx + 1;
        }
        if (t1 > this.osty) {
            t1 = this.osty;
        }
        if (b1 < this.osty + 1) {
            b1 = this.osty + 1;
        }
        this.repaint(l1 * this.Cw, t1 * this.Ch, (r1 - l1) * this.Cw, (b1 - t1) * this.Ch);
        if (this.score != this.oscore) {
            this.repaint(0, this.h - this.Fh, this.w, this.Fh);
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.mode == 3 || this.mode == 4) {
            if ((keyCode == this.KEY_UP || keyCode == 50 || keyCode == -13) && this.cdiffy > 0) {
                --this.cdiffy;
                this.repaint();
            } else if ((keyCode == this.KEY_DOWN || keyCode == 56 || keyCode == -14) && this.cdiffy < 7) {
                ++this.cdiffy;
                this.repaint();
            } else if (keyCode == 42 || keyCode == 35) {
                if (this.mode == 3) {
                    this.saveDiffyMr();
                } else if (this.mode == 4) {
                    this.saveDiffyAr();
                }
                this.mode = this.oldmode;
                this.resumeGame();
                this.repaint();
            }
            return;
        }
        if (keyCode == 48) {
            this.pauseResume();
        } else {
            if (keyCode == 42) {
                this.oldmode = this.mode;
                this.mode = 3;
                this.pauseGame();
                this.loadDiffy(this.Di, this.Mr);
                this.repaint();
                return;
            }
            if (keyCode == 35) {
                this.oldmode = this.mode;
                this.mode = 4;
                this.pauseGame();
                this.loadDiffy(this.Da, this.Ar);
                this.repaint();
                return;
            }
        }
        if (this.moving || this.paused > 0 || this.gameover || this.fdir == null || this.field == null) {
            return;
        }
        int dir = this.fdir[this.shy * this.sx + this.shx] >> 4;
        int tdir = this.fdir[this.shy * this.sx + this.shx] & 0xF;
        if ((keyCode == this.KEY_LEFT || keyCode == 52) && tdir != 1) {
            this.fdir[this.shy * this.sx + this.shx] = tdir | 0x10;
        } else if ((keyCode == this.KEY_RIGHT || keyCode == 54) && tdir != 3) {
            this.fdir[this.shy * this.sx + this.shx] = tdir | 0x30;
        } else if ((keyCode == this.KEY_UP || keyCode == 50) && tdir != 2) {
            this.fdir[this.shy * this.sx + this.shx] = tdir | 0x20;
        } else if ((keyCode == this.KEY_DOWN || keyCode == 56) && tdir != 4) {
            this.fdir[this.shy * this.sx + this.shx] = tdir | 0x40;
        }
    }

    protected void keyReleased(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
    }
}

