/*
 * Decompiled with CFR 0.152.
 */
package com.vmx;

import javax.microedition.lcdui.Font;

public class FontWidthCache {
    private Font font;
    private byte[][] caches;

    public FontWidthCache(Font font) {
        this.font = font;
        this.caches = new byte[256][];
        for (int i = 0; i < 256; ++i) {
            this.caches[i] = null;
        }
    }

    public int charWidth(char ch) {
        int hi = ch >> 8 & 0xFF;
        int lo = ch & 0xFF;
        if (this.caches[hi] == null) {
            this.caches[hi] = new byte[256];
            for (int i = 0; i < 256; ++i) {
                this.caches[hi][i] = -1;
            }
        }
        if (this.caches[hi][lo] == -1) {
            this.caches[hi][lo] = (byte)this.font.charWidth(ch);
        }
        return this.caches[hi][lo];
    }

    public int stringWidth(String s) {
        int l = s.length();
        int r = 0;
        for (int i = 0; i < l; ++i) {
            r += this.charWidth(s.charAt(i));
        }
        return r;
    }
}

