package com.vmx;

import javax.microedition.lcdui.Font;

public class FontWidthCache
{
    private Font font;
    private byte caches [][];
    public FontWidthCache (Font font)
    {
        this.font = font;
        caches = new byte [256][];
        for (int i = 0; i < 256; i++)
            caches [i] = null;
    }
    public int charWidth (char ch)
    {
        int hi = (ch >> 8)&0xFF, lo = (ch)&0xFF;
        if (caches [hi] == null)
        {
            caches [hi] = new byte [256];
            for (int i = 0; i < 256; i++)
                caches [hi][i] = -1;
        }
        if (caches [hi][lo] == -1)
            caches [hi][lo] = (byte)font.charWidth (ch);
        return caches [hi][lo];
    }
    public int stringWidth (String s)
    {
        int l = s.length (), i, r;
        for (r = 0, i = 0; i < l; i++)
            r += charWidth(s.charAt(i));
        return r;
    }
}
